<?php
// index.php — 🤖 ربات محصول‌یاب «محصولینو»  
// ✅ نسخه فایلی — هر کاربر یک پوشه، هر داده یک فایل جداگانه: points.json, inviter.json, referral.json

// اعتبارسنجی IP تلگرام
$telegram_ips = [
    ['lower' => '149.154.160.0', 'upper' => '149.154.175.255'],
    ['lower' => '91.108.4.0',    'upper' => '91.108.7.255'],
];
$ip_dec = (float) sprintf("%u", ip2long($_SERVER['REMOTE_ADDR']));
$ok = false;
foreach ($telegram_ips as $r) {
    $low = (float) sprintf("%u", ip2long($r['lower']));
    $up  = (float) sprintf("%u", ip2long($r['upper']));
    if ($ip_dec >= $low && $ip_dec <= $up) { $ok = true; break; }
}
if (!$ok) { http_response_code(403); die('ok'); }

ini_set('max_execution_time', 30);
ini_set('memory_limit', '64M');
error_reporting(0);
ignore_user_abort(true);
date_default_timezone_set('Asia/Tehran');

define('API_KEY', '8506011836:AAFFdspiFwc7Y5_54zFkH_pVSISAAdIbiEo');
define('BOT_USERNAME', 'hiskaplus_kalayabbot'); // نام کاربری ربات بدون @
define('REQUIRED_CHANNELS', ['@nextito', '@hiska_plus']);
define('DATA_DIR', __DIR__ . '/data');
define('ADMIN_IDS', [7206538025, 5514025236]);

// لاگ ساده برای دیباگ
function log_debug($msg) {
    $file = DATA_DIR . '/debug.log';
    $line = '[' . date('Y-m-d H:i:s') . '] ' . $msg . "\n";
    @file_put_contents($file, $line, FILE_APPEND | LOCK_EX);
}

// === توابع مدیریت فایل‌های کاربر (جدید — هر داده یک فایل) ===
function getUserDataDir($user_id) {
    $user_id = (int)$user_id;
    if ($user_id <= 0) return false;
    $dir = DATA_DIR . '/' . $user_id;
    if (!is_dir($dir)) {
        @mkdir($dir, 0755, true);
    }
    return $dir;
}

function getUserFile($user_id, $filename) {
    $dir = getUserDataDir($user_id);
    if (!$dir) return false;
    return $dir . '/' . $filename;
}

// --- points.json (سیستم ساده امتیاز) ---
function getPoints($user_id) {
    $file = getUserFile($user_id, 'points.json');
    if (!$file || !file_exists($file)) return 0;
    $raw = @file_get_contents($file);
    $data = @json_decode($raw, true);
    return isset($data['points']) ? (int)$data['points'] : 0;
}

function setPoints($user_id, $points) {
    $file = getUserFile($user_id, 'points.json');
    if (!$file) return false;
    $json = json_encode(['points' => (int)$points], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    return @file_put_contents($file, $json) !== false;
}

function givePoints($user_id, $amount = 1) {
    $current = getPoints($user_id);
    return setPoints($user_id, $current + (int)$amount);
}

// --- inviter.json (فقط یک بار نگه می‌داریم چه کسی دعوت کرده) ---
function getReferredBy($user_id) {
    $file = getUserFile($user_id, 'inviter.json');
    if (!$file || !file_exists($file)) return null;
    $raw = @file_get_contents($file);
    $data = @json_decode($raw, true);
    return isset($data['referred_by']) ? (int)$data['referred_by'] : null;
}

function setReferredBy($user_id, $referrer_id) {
    $file = getUserFile($user_id, 'inviter.json');
    if (!$file) return false;
    // هنگام ثبت معرف، فیلد rewarded را false می‌گذاریم تا بعداً فقط یک بار امتیاز بدهیم
    $json = json_encode([
        'referred_by' => (int)$referrer_id,
        'rewarded'    => false,
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    return @file_put_contents($file, $json) !== false;
}

function isReferralRewarded($user_id) {
    $file = getUserFile($user_id, 'inviter.json');
    if (!$file || !file_exists($file)) return false;
    $raw = @file_get_contents($file);
    $data = @json_decode($raw, true);
    return !empty($data['rewarded']);
}

function setReferralRewarded($user_id) {
    $file = getUserFile($user_id, 'inviter.json');
    if (!$file || !file_exists($file)) return false;
    $raw = @file_get_contents($file);
    $data = @json_decode($raw, true);
    if (!is_array($data)) $data = [];
    $data['rewarded'] = true;
    $json = json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    return @file_put_contents($file, $json) !== false;
}

function rewardReferralIfNeeded($user_id) {
    $ref_id = getReferredBy($user_id);
    if (!$ref_id || $ref_id === $user_id) return;
    if (isReferralRewarded($user_id)) return;

    givePoints($ref_id, 1);
    setReferralRewarded($user_id);

    $new_points = getPoints($ref_id);
    callBot('sendMessage', [
        'chat_id' => $ref_id,
        'text' => "🎉 یک زیرمجموعه جدید گرفتی!\nامتیاز فعلی تو: <b>{$new_points}</b>",
        'parse_mode' => 'HTML'
    ]);
}

// --- compare_list.json ---
function getCompareList($user_id) {
    $file = getUserFile($user_id, 'compare_list.json');
    if (!$file || !file_exists($file)) return [];
    $raw = @file_get_contents($file);
    $list = @json_decode($raw, true);
    return is_array($list) ? $list : [];
}

function setCompareList($user_id, $list) {
    $file = getUserFile($user_id, 'compare_list.json');
    if (!$file) return false;
    $json = json_encode(array_values($list), JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    return @file_put_contents($file, $json) !== false;
}

function addToCompareList($user_id, $product) {
    $list = getCompareList($user_id);
    if (count($list) >= 2) return false;
    $list[] = $product;
    return setCompareList($user_id, $list);
}

function removeFromCompareList($user_id, $index) {
    $list = getCompareList($user_id);
    if (isset($list[$index])) {
        unset($list[$index]);
        return setCompareList($user_id, $list);
    }
    return false;
}

function removeFromCompareListByKey($user_id, $random_key) {
    $list = getCompareList($user_id);
    foreach ($list as $i => $p) {
        if (($p['random_key'] ?? null) === $random_key) {
            unset($list[$i]);
            return setCompareList($user_id, $list);
        }
    }
    return false;
}

function isInCompareListByKey($user_id, $random_key) {
    $list = getCompareList($user_id);
    foreach ($list as $p) {
        if (($p['random_key'] ?? null) === $random_key) return true;
    }
    return false;
}

function removeItemFromCompareListByKey($user_id, $random_key) {
    return removeFromCompareListByKey($user_id, $random_key);
}

function isItemInCompareListByKey($user_id, $random_key) {
    return isInCompareListByKey($user_id, $random_key);
}

// --- favorites.json --- (لیست علاقه‌مندی‌های کاربر)
function getFavorites($user_id) {
    $file = getUserFile($user_id, 'favorites.json');
    if (!$file || !file_exists($file)) return [];
    $raw = @file_get_contents($file);
    $list = @json_decode($raw, true);
    return is_array($list) ? $list : [];
}

function setFavorites($user_id, $list) {
    $file = getUserFile($user_id, 'favorites.json');
    if (!$file) return false;
    $json = json_encode(array_values($list), JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    return @file_put_contents($file, $json) !== false;
}

function addFavorite($user_id, $product) {
    $list = getFavorites($user_id);
    $list[] = $product;
    return setFavorites($user_id, $list);
}

function removeFavorite($user_id, $product) {
    $list = getFavorites($user_id);
    $index = array_search($product, $list);
    if ($index !== false) {
        unset($list[$index]);
        return setFavorites($user_id, $list);
    }
    return false;
}

function isFavoriteByKey($user_id, $random_key) {
    $list = getFavorites($user_id);
    foreach ($list as $p) {
        if (($p['random_key'] ?? null) === $random_key) {
            return true;
        }
    }
    return false;
}

function removeFavoriteByKey($user_id, $random_key) {
    $list = getFavorites($user_id);
    foreach ($list as $i => $p) {
        if (($p['random_key'] ?? null) === $random_key) {
            unset($list[$i]);
            return setFavorites($user_id, $list);
        }
    }
    return false;
}

function buildProductKeyboard($random_key, $is_fav, $in_compare = false) {
    $fav_text = $is_fav ? '❌ حذف از علاقه‌مندی‌ها' : '⭐ افزودن به علاقه‌مندی‌ها';
    $fav_cb = $is_fav ? 'fav_remove:' . $random_key : 'fav_add:' . $random_key;

    $cmp_text = $in_compare ? '❌ حذف از مقایسه' : '➕ افزودن به مقایسه';
    $cmp_cb = $in_compare ? 'cmp_remove:' . $random_key : 'cmp_add:' . $random_key;

    return json_encode([
        'inline_keyboard' => [
            [['text' => '🛍 لیست فروشنده‌ها', 'switch_inline_query_current_chat' => 'sellers_' . $random_key]],
            [['text' => $fav_text, 'callback_data' => $fav_cb]],
            [['text' => $cmp_text, 'callback_data' => $cmp_cb]],
            [['text' => '🔍 جستجوی مجدد', 'switch_inline_query_current_chat' => '']],
            [['text' => '⬅️ بازگشت به منوی اصلی', 'callback_data' => 'main_menu']],
        ]
    ]);
}

// === توابع کمکی ربات ===
function callBot($method, $data = []) {
    $url = "https://api.telegram.org/bot" . API_KEY . "/" . $method; // 
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
    $res = curl_exec($ch);
    curl_close($ch);
    return $res;
}

function tr($price) {
    $p = intval($price);
    if ($p >= 10000000000) $p = $p / 10;
    return number_format($p, 0, '.', ',') . ' تومان';
}

function isUserMember($chat_id) {
    foreach (REQUIRED_CHANNELS as $channel) {
        $res = json_decode(callBot('getChatMember', [
            'chat_id' => $channel,
            'user_id' => $chat_id
        ]), true);
        $status = $res['result']['status'] ?? '';
        if (!in_array($status, ['member', 'administrator', 'creator'])) {
            return false;
        }
    }
    return true;
}

function sendJoinRequired($chat_id) {
    $text = "🔐 <b>عضویت اجباری</b>\n\n" .
            "برای استفاده از ربات، اول تو کانال‌های زیر عضو شو:\n" .
            "• @nextito\n" .
            "• @hiska_plus\n\n" .
            "بعد که عضو شدی، برگرد /start رو تو ربات بفرست.";

    $keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '⚡ عضویت در نکستیتو', 'url' => 'https://t.me/nextito']],
            [['text' => '🌟 عضویت در هیسکا پلاس', 'url' => 'https://t.me/hiska_plus']],
            [['text' => '✅ عضو شدم، بررسی کن', 'callback_data' => 'check_membership']]
        ]
    ]);

    callBot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard,
        'disable_web_page_preview' => true
    ]);
}

function isAdmin($chat_id) {
    $id = (int)$chat_id;
    return in_array($id, ADMIN_IDS, true);
}

function getChatLabelById($chat_id) {
    $uid = (int)$chat_id;
    if ($uid <= 0) return 'نامشخص';

    $res = json_decode(callBot('getChat', [
        'chat_id' => $uid
    ]), true);

    if (!is_array($res) || !($res['ok'] ?? false)) {
        return (string)$uid;
    }

    $chat = $res['result'] ?? [];
    $username = trim($chat['username'] ?? '');
    if ($username !== '') {
        return '@' . $username;
    }

    $first = trim($chat['first_name'] ?? '');
    $last = trim($chat['last_name'] ?? '');
    $name = trim($first . ' ' . $last);
    if ($name !== '') {
        return $name . ' (' . $uid . ')';
    }

    return (string)$uid;
}

// --- دریافت ورودی ---
$update = json_decode(file_get_contents('php://input'), true);
$chat_id = $update['message']['chat']['id'] ?? null;
$text = $update['message']['text'] ?? '';
$query_id = $update['inline_query']['id'] ?? null;
$q = trim($update['inline_query']['query'] ?? '');
$callback = $update['callback_query']['data'] ?? null;
$cid = $update['callback_query']['id'] ?? null;
$cid_chat = $update['callback_query']['message']['chat']['id'] ?? null;
$mid = $update['callback_query']['message']['message_id'] ?? null;

// --- هندل /start ---
if ($chat_id && isset($update['message']['text']) && str_starts_with($update['message']['text'], '/start')) {

    // تشخیص اینکه این کاربر قبلاً پوشه داده داشته یا نه
    $user_dir_path = DATA_DIR . '/' . (int)$chat_id;
    $was_new_user = !is_dir($user_dir_path);

    // ایجاد پوشه داده کاربر (اگر وجود نداشت) تا برای دفعات بعدی جدید حساب نشود
    getUserDataDir($chat_id);

    // اگر با لینک دعوت /start <ref_id> آمده و کاربر تازه است، معرف را ثبت کن
    $ref_id = null;
    $start_text = $update['message']['text'];
    // پشتیبانی از /start یا /start@BotName با فاصله و اسپیس اضافه
    if (preg_match('/^\/start(?:@\w+)?\s+(\d+)\s*$/', $start_text, $m)) {
        $ref_id = (int)$m[1];
    }

    if ($was_new_user && $ref_id && $ref_id !== $chat_id) {
        // ثبت معرف برای این کاربر (امتیاز بعد از تایید عضویت داده می‌شود)
        setReferredBy($chat_id, $ref_id);
    }

    // منوی اصلی (فقط جستجو و امکانات ساده)
    $keyboard = json_encode([
        'inline_keyboard' => [
            [
                ['text' => '🔍 جستجوی کالا', 'switch_inline_query_current_chat' => '']
            ],
            [
                ['text' => '🏷️ تخفیف‌یاب', 'switch_inline_query_current_chat' => 'deals'],
                ['text' => '🏆 گرفتن امتیاز', 'callback_data' => 'earn_points']
            ],
            [
                ['text' => '⭐ علاقه‌مندی‌ها', 'callback_data' => 'favorites']
            ],
            [
                ['text' => '📊 مقایسهٔ کالاها', 'callback_data' => 'cmp_show']
            ],
            [
                ['text' => '🐞 ریپورت باگ', 'callback_data' => 'report_bug']
            ]
        ]
    ]);

    callBot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "🤖 <b>ربات کالا یاب هیسکا</b>\n\n" .
                  "💰 پایین‌ترین قیمت‌ها رو تو ۲۰۰+ فروشگاه معتبر ایرانی پیدا کن!\n" .
                  "⚡ جستجوی لحظه‌ای — بدون ثبت‌نام — بدون تبلیغات\n\n" .
                  "👇 برای شروع، دکمه‌ی زیر رو بزن و اسم کالایی که می‌خوای رو بنویس:",
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
    die('ok');
}

// --- هندل /admin (پنل مدیریت) ---
if ($chat_id && isset($update['message']['text']) && str_starts_with($update['message']['text'], '/admin')) {
    if (!isAdmin($chat_id)) {
        callBot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "❌ شما دسترسی به پنل مدیریت ندارید."
        ]);
        die('ok');
    }

    $kb = json_encode([
        'inline_keyboard' => [
            [
                ['text' => '📊 آمار ربات', 'callback_data' => 'admin_stats']
            ],
            [
                ['text' => '📢 راهنمای پیام همگانی', 'callback_data' => 'admin_broadcast_info']
            ],
            [
                ['text' => '✉️ راهنمای پیام به کاربر', 'callback_data' => 'admin_pm_info']
            ],
            [
                ['text' => '⬅️ بازگشت به منوی اصلی', 'callback_data' => 'main_menu']
            ]
        ]
    ]);

    callBot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "👑 <b>پنل مدیریت ربات</b>\n\nاز دکمه‌های زیر می‌تونی آمار ربات رو ببینی یا راهنمای ارسال پیام همگانی و پیام به کاربر رو بگیری.\n\nدستورات متنی ادمین:\n• /stats — نمایش آمار کلی کاربران ربات\n• /broadcast متن — ارسال پیام همگانی به همه کاربران\n• /pm chat_id متن — ارسال پیام خصوصی به یک کاربر مشخص",
        'parse_mode' => 'HTML',
        'reply_markup' => $kb
    ]);
    die('ok');
}

function getAllUserIds() {
    $ids = [];
    if (!is_dir(DATA_DIR)) return $ids;
    $items = @scandir(DATA_DIR);
    if (!is_array($items)) return $ids;
    foreach ($items as $it) {
        if ($it === '.' || $it === '..') continue;
        if (!ctype_digit($it)) continue;
        $full = DATA_DIR . '/' . $it;
        if (is_dir($full)) {
            $ids[] = (int)$it;
        }
    }
    return $ids;
}

// --- دستورات متنی ادمین ---
if ($chat_id && isset($update['message']['text']) && isAdmin($chat_id)) {
    $msgText = trim($update['message']['text']);

    if (str_starts_with($msgText, '/stats')) {
        $userIds = getAllUserIds();
        $totalUsers = count($userIds);

        $textStats = "📊 آمار کلی ربات\n\n" .
                     "تعداد کل کاربران ثبت‌شده: <b>{$totalUsers}</b>";

        callBot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $textStats,
            'parse_mode' => 'HTML'
        ]);
        die('ok');
    }

    if (str_starts_with($msgText, '/broadcast')) {
        $payload = trim(substr($msgText, strlen('/broadcast')));
        if ($payload === '') {
            callBot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => 'برای پیام همگانی بنویس: /broadcast متن پیام'
            ]);
            die('ok');
        }

        $userIds = getAllUserIds();
        $okCount = 0;
        $failCount = 0;
        foreach ($userIds as $uid) {
            $res = callBot('sendMessage', [
                'chat_id' => $uid,
                'text' => $payload
            ]);
            if ($res) {
                $okCount++;
            } else {
                $failCount++;
            }
        }

        $report = "پیام همگانی ارسال شد.\nموفق: {$okCount}\nناموفق: {$failCount}";
        callBot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => $report
        ]);
        die('ok');
    }

    if (str_starts_with($msgText, '/pm ')) {
        $rest = trim(substr($msgText, 4));
        if ($rest === '') {
            callBot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => 'فرمت صحیح: /pm chat_id متن پیام'
            ]);
            die('ok');
        }

        if (!preg_match('/^(\d+)\s+(.+)$/u', $rest, $m)) {
            callBot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => 'فرمت صحیح: /pm chat_id متن پیام'
            ]);
            die('ok');
        }

        $targetId = (int)$m[1];
        $pmText = trim($m[2]);

        if ($pmText === '') {
            callBot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => 'متن پیام خالی است.'
            ]);
            die('ok');
        }

        $res = callBot('sendMessage', [
            'chat_id' => $targetId,
            'text' => $pmText
        ]);

        if ($res) {
            callBot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => 'پیام برای کاربر ارسال شد.'
            ]);
        } else {
            callBot('sendMessage', [
                'chat_id' => $chat_id,
                'text' => 'ارسال پیام به کاربر ناموفق بود.'
            ]);
        }
        die('ok');
    }
}

// --- بخش inline query ---
if (isset($update['inline_query'])) {
    $user_id = $update['inline_query']['from']['id'] ?? null;
    if (!isUserMember($user_id)) {
        $join_result = [
            'type' => 'article',
            'id' => 'join',
            'title' => '🔐 اول عضو کانال‌ها شو',
            'description' => 'برای کار با ربات، باید تو کانال‌ها عضو باشی.',
            'input_message_content' => [
                'message_text' => "🔐 برای استفاده از ربات، اول تو این دو کانال عضو شو:\n\n• @nextito\n• @hiska_plus",
                'parse_mode' => 'HTML'
            ],
        ];

        callBot('answerInlineQuery', [
            'inline_query_id' => $query_id,
            'results' => json_encode([$join_result], JSON_UNESCAPED_UNICODE),
            'cache_time' => 0,
            'is_personal' => true
        ]);
        die('ok');
    }

    $q = trim($update['inline_query']['query']);

    // --- لیست تخفیف‌ها (deals) از offch برای همهٔ فروشگاه‌ها ---
    if ($q !== '' && preg_match('/^deals\b/iu', $q)) {
        $query_id = $update['inline_query']['id'];

        // از endpoint عمومی بدون محدود کردن به یک shop خاص 
        $apiUrl = 'https://api.offch.com/api/v2/coupons/coupons/?is_expired=false&page=shop&type=no_prize&limit=200&ordering=-publish_datetime';

        $ch = curl_init($apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $resp = curl_exec($ch);
        $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        $results = [];
        if ($http === 200 && $resp) {
            $dec = json_decode($resp, true);
            $rows = $dec['results'] ?? [];
            $i = 0;
            foreach ($rows as $row) {

                $id    = intval($row['id'] ?? 0);
                $title = trim($row['title'] ?? '');
                $pretty = trim($row['pretty_value'] ?? '');
                $expire = trim($row['pretty_expire_datetime'] ?? '');
                $slug   = trim($row['url'] ?? ''); // مثل /codes/10679/...

                if (!$id || $slug === '') continue;

                $descParts = [];
                if ($pretty !== '') $descParts[] = $pretty;
                if ($expire !== '') $descParts[] = $expire;
                $desc = $descParts ? implode(' • ', $descParts) : '';

                // payload برای پیام بعدی؛ کد تخفیف اینجا نمایش داده نمی‌شود
                $payload = 'offch_coupon|' . $id . '|' . $slug . '|' . str_replace('|', ' ', $title) . '|' . str_replace('|', ' ', $pretty) . '|' . str_replace('|', ' ', $expire);

                $results[] = [
                    'type' => 'article',
                    'id'   => 'offch_' . $id,
                    'title' => ($title !== '' ? $title : 'کد تخفیف #' . $id),
                    'description' => $desc,
                    'input_message_content' => [
                        'message_text' => $payload,
                        'parse_mode' => 'HTML'
                    ]
                ];

                $i++;
                // حداکثر ۳۰ نتیجه برای اینلاین نمایش بده تا خیلی شلوغ نشود
                if ($i >= 30) break;
            }
        }

        if (empty($results)) {
            $results[] = [
                'type' => 'article',
                'id'   => 'offch_empty',
                'title' => 'کدی پیدا نشد',
                'description' => 'فعلاً تخفیفی نداریم',
                'input_message_content' => [
                    'message_text' => 'فعلاً کدی پیدا نشد.'
                ]
            ];
        }

        callBot('answerInlineQuery', [
            'inline_query_id' => $query_id,
            'results' => json_encode($results, JSON_UNESCAPED_UNICODE),
            'cache_time' => 10,
            'is_personal' => true
        ]);
        die('ok');
    }

    // --- لیست علاقه‌مندی‌ها (love_list) ---
    if ($q === 'love_list') {
        $favorites = getFavorites($user_id);
        $results = [];

        if (empty($favorites)) {
            $results[] = [
                'type' => 'article',
                'id' => 'no_fav',
                'title' => '📭 لیست علاقه‌مندی‌ها خالی است',
                'description' => 'هنوز کالایی را به علاقه‌مندی‌ها اضافه نکرده‌اید.',
                'input_message_content' => ['message_text' => "🔖 هنوز هیچ کالایی در علاقه‌مندی‌ها ثبت نشده است."]
            ];
        } else {
            foreach ($favorites as $idx => $p) {
                $name = htmlspecialchars($p['name'] ?? '---');
                $price = intval($p['price'] ?? 0);
                $toman = $price > 0 ? tr($price) : 'ناموجود';
                $img = $p['image_url'] ?? '';

                $desc = $toman;
                $results[] = [
                    'type' => 'article',
                    'id' => 'fav_' . ($idx),
                    'title' => '⭐ ' . $name,
                    'description' => $desc,
                    'thumb_url' => $img,
                    'input_message_content' => [
                        'message_text' => "product_" . ($p['random_key'] ?? ''),
                        'parse_mode' => 'HTML'
                    ]
                ];
            }
        }

        callBot('answerInlineQuery', [
            'inline_query_id' => $query_id,
            'results' => json_encode($results, JSON_UNESCAPED_UNICODE),
            'cache_time' => 5,
            'is_personal' => true
        ]);
        die('ok');
    }

    // --- لیست مقایسه برای نمایش محصولات لیست (cmp_list) ---
    if ($q === 'cmp_list') {
        $compare = getCompareList($user_id);
        $results = [];

        if (empty($compare)) {
            $results[] = [
                'type' => 'article',
                'id' => 'no_cmp',
                'title' => '📊 لیست مقایسه خالی است',
                'description' => 'هنوز کالایی را به لیست مقایسه اضافه نکرده‌اید.',
                'input_message_content' => ['message_text' => "📊 هنوز هیچ کالایی برای مقایسه ثبت نشده است."]
            ];
        } else {
            foreach ($compare as $idx => $p) {
                $name = htmlspecialchars($p['name'] ?? '---');
                $price = intval($p['price'] ?? 0);
                $toman = $price > 0 ? tr($price) : 'ناموجود';
                $img = $p['image_url'] ?? '';
                $rk = $p['random_key'] ?? '';

                $results[] = [
                    'type' => 'article',
                    'id' => 'cmp_' . ($idx),
                    'title' => '📦 ' . $name,
                    'description' => $toman,
                    'thumb_url' => $img,
                    'input_message_content' => [
                        'message_text' => 'product_' . $rk,
                        'parse_mode' => 'HTML'
                    ]
                ];
            }
        }

        callBot('answerInlineQuery', [
            'inline_query_id' => $query_id,
            'results' => json_encode($results, JSON_UNESCAPED_UNICODE),
            'cache_time' => 5,
            'is_personal' => true
        ]);
        die('ok');
    }

    // --- اشتراک‌گذاری لینک دعوت (share_link) ---
    if ($q === 'share_link') {
        $points = getPoints($user_id);
        $link = "https://t.me/" . BOT_USERNAME . "?start=" . $user_id;

        $results = [
            [
                'type' => 'article',
                'id' => 'share_invite',
                'title' => '📤 اشتراک‌گذاری لینک دعوت من',
                'description' => "امتیاز فعلی: {$points}",
                'input_message_content' => [
                    'message_text' => "🎁 بیا با این ربات قیمت کالاها رو پیدا کنیم!\n\nلینک دعوت من:\n" . $link,
                    'parse_mode' => 'HTML'
                ]
            ]
        ];

        callBot('answerInlineQuery', [
            'inline_query_id' => $query_id,
            'results' => json_encode($results, JSON_UNESCAPED_UNICODE),
            'cache_time' => 5,
            'is_personal' => true
        ]);
        die('ok');
    }

    // --- لیست فروشنده‌ها — بدون تغییر ---
    if (strpos($q, "sellers_") === 0) {
        $random_key = str_replace("sellers_", "", $q);
        $url = "https://api.torob.com/v4/base-product/details/?prk=" . urlencode($random_key) . "&max_seller_count=30&deliver_city=1121"; // 
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $raw = curl_exec($ch);
        curl_close($ch);

        $data = json_decode($raw, true);
        $shops = $data['products_info']['result'] ?? [];

        $results = [];
        if (empty($shops)) {
            $results[] = [
                'type' => 'article',
                'id' => 'no_sellers',
                'title' => '🛒 هیچ فروشنده‌ای یافت نشد!',
                'input_message_content' => ['message_text' => "❌ متاسفانه فروشنده‌ای برای این کالا یافت نشد."]
            ];
        } else {
            // تحلیل برای پیدا کردن فروشنده‌ها
            $bestIndex = null;      // 🥇 بالاترین امتیاز بین فروشنده‌های قابل‌نمایش
            $bestRating = -1;
            $bestReviews = -1;
            $bestPrice = PHP_INT_MAX;

            $cheapestIndex = null;  // 💰 کمترین قیمت بین فروشنده‌های قابل‌نمایش
            $minPrice = PHP_INT_MAX;

            foreach ($shops as $i => $shop) {
                $url = $shop['page_url'] ?? '';
                if (empty($url)) continue; // فقط فروشنده‌هایی که واقعاً نمایش داده می‌شوند

                $price = intval($shop['price'] ?? 0);
                if ($price > 0 && $price < $minPrice) {
                    $minPrice = $price;
                    $cheapestIndex = $i;
                }

                // انتخاب «برترین» فقط بر اساس امتیاز، سپس تعداد نظر و در نهایت قیمت
                $rating = floatval($shop['shop_rating'] ?? 0);
                $reviews = intval($shop['shop_review_count'] ?? 0);
                if ($rating <= 0) continue; // فقط فروشنده‌هایی که امتیاز دارند

                if (
                    $rating > $bestRating ||
                    ($rating === $bestRating && $reviews > $bestReviews) ||
                    ($rating === $bestRating && $reviews === $bestReviews && $price > 0 && $price < $bestPrice)
                ) {
                    $bestRating = $rating;
                    $bestReviews = $reviews;
                    $bestPrice = $price > 0 ? $price : $bestPrice;
                    $bestIndex = $i;
                }
            }

            foreach ($shops as $i => $shop) {
                $shop_name = htmlspecialchars($shop['shop_name'] ?? 'نامشخص');
                $price = intval($shop['price'] ?? 0);
                $toman = $price > 0 ? tr($price) : 'ناموجود';
                $url = $shop['page_url'] ?? '';
                if (empty($url)) continue;

                $rating = floatval($shop['shop_rating'] ?? 0);
                $reviews = intval($shop['shop_review_count'] ?? 0);
                $isOfficial = ($shop['is_official_shop'] ?? false) === true;
                $inStock = ($shop['is_in_stock'] ?? true) === true;
                $delivery = $shop['delivery_text'] ?? '';

                // اطلاعات تکمیلی برای UX بهتر
                $score_text = $shop['score_info']['score_text'] ?? '';
                // فقط بخش امتیاز (مثل ★۴.۸) را نگه می‌داریم
                if ($score_text) {
                    $parts = explode(' ', trim($score_text), 2);
                    $score_text = $parts[0] ?? $score_text;
                }

                $payment_on_delivery = $shop['more_info']['payment_on_delivery'] ?? '';
                $shipping_types = $shop['more_info']['shipping_types'] ?? [];

                // 🏷️ ساخت برچسب‌ها
                $badges = [];
                if ($i === $bestIndex) $badges[] = '🥇 برترین';
                if ($i === $cheapestIndex) $badges[] = '💰 ارزان‌ترین';
                if ($isOfficial) $badges[] = '🏢 رسمی';
                if ($rating >= 4.7 && $reviews > 20) $badges[] = '⭐ ' . number_format($rating, 1);
                if ($payment_on_delivery) $badges[] = '💳 پرداخت در محل';
                if (!$inStock) $badges[] = '⚠️ موجود نیست';

                $badgeStr = $badges ? ' [' . implode(' • ', $badges) . ']' : '';

                // 📝 متن پیام — برای بهترین فروشنده، جزئیات بیشتر
                $msg = "🛍 <b>{$shop_name}</b>{$badgeStr}\n💰 قیمت: <b>{$toman}</b>";
                if ($rating > 0) $msg .= "\n⭐ امتیاز: {$rating} ({$reviews} نظر)";
                if ($score_text) $msg .= "\n📊 {$score_text}";
                if ($delivery) $msg .= "\n📦 {$delivery}";
                if (!empty($shipping_types) && is_array($shipping_types)) {
                    $msg .= "\n🚚 ارسال: " . implode('، ', $shipping_types);
                }

                $keyboard = [
                    'inline_keyboard' => [
                        [['text' => '🛒 خرید از این فروشگاه', 'url' => $url]],
                        [['text' => '🔄 لیست دیگر فروشنده‌ها', 'switch_inline_query_current_chat' => "sellers_" . $random_key]]
                    ]
                ];

                $results[] = [
                    'type' => 'article',
                    'id' => 'shop_' . md5($url . $i),
                    'title' => '🛍 ' . $shop_name . $badgeStr,
                    'description' => $toman . ($delivery ? " • {$delivery}" : ''),
                    'input_message_content' => ['message_text' => $msg, 'parse_mode' => 'HTML'],
                    'reply_markup' => $keyboard
                ];
            }
        }

        callBot('answerInlineQuery', [
            'inline_query_id' => $query_id,
            'results' => json_encode($results, JSON_UNESCAPED_UNICODE),
            'cache_time' => 10,
            'is_personal' => true
        ]);
        die('ok');
    }

    // جستجوی متنی
    if ($q === '') {
        callBot('answerInlineQuery', [
            'inline_query_id' => $query_id,
            'results' => json_encode([
                [
                    'type' => 'article',
                    'id' => 'help',
                    'title' => '🔍 مثال: "کتاب سال بلوا "، "یخچال"',
                    'description' => 'جستجو در 1900+ فروشگاه معتبر ایرانی',
                    'input_message_content' => ['message_text' => "🤖 لطفاً یک کالا را جستجو کنید..."],
                ]
            ], JSON_UNESCAPED_UNICODE),
            'cache_time' => 30,
            'is_personal' => true
        ]);
        die('ok');
    }

    $url = "https://api.torob.com/v4/base-product/search/?page=0&sort=popularity&size=24&query="
         . urlencode($q)
         . "&q=" . urlencode($q) . "&_landing_page=home&source=next_desktop"; // 

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $raw = curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    log_debug("inline_search request q='{$q}' code={$code} len=" . strlen((string)$raw));

    $results = [];
    if ($code !== 200 || !$raw) {
        $results[] = [
            'type' => 'article',
            'id' => 'err_1',
            'title' => '⚠️ خطای اتصال',
            'description' => 'مشکلی در دریافت داده‌ها رخ داد',
            'input_message_content' => ['message_text' => "❌ لطفاً دوباره امتحان کنید."],
        ];
    } else {
        $data = json_decode($raw, true);
        $items = $data['results'] ?? [];
        log_debug("inline_search parsed q='{$q}' items_count=" . count((array)$items));

        if (empty($items)) {
            $results[] = [
                'type' => 'article',
                'id' => 'no_1',
                'title' => '🤷‍♂️ چیزی پیدا نشد!',
                'description' => 'عبارتی که جستجو کردید موجود نیست',
                'input_message_content' => ['message_text' => "🔍 عبارت «<b>{$q}</b>» یافت نشد."],
            ];
        } else {
            foreach (array_slice($items, 0, 24) as $idx => $item) {
                $name = htmlspecialchars($item['name1'] ?? '---');
                $price = intval($item['price'] ?? 0);
                $price_text = $price > 0 ? tr($price) : 'ناموجود';
                $shop_text = $item['shop_text'] ?? '';
                $name2 = $item['name2'] ?? '';
                $img = $item['image_url'] ?? '';

                // توضیح غنی‌تر: قیمت + فروشگاه‌ها + عنوان انگلیسی در صورت وجود
                $parts = [];
                $parts[] = $price_text;
                if ($shop_text) $parts[] = $shop_text;
                if ($name2) $parts[] = $name2;
                $desc = implode(' • ', $parts);

                // id باید برای هر نتیجه در یک پاسخ اینلاین یکتا باشد؛
                // از random_key به‌همراه اندیس استفاده می‌کنیم تا تکراری نشود.
                $rk = $item['random_key'] ?? md5($name);
                $safe_id = 'p_' . md5($rk . '_' . $idx);

                $results[] = [
                    'type' => 'article',
                    'id' => $safe_id,
                    'title' => $name,
                    'description' => $desc,
                    'thumb_url' => $img,
                    'input_message_content' => [
                        'message_text' => "product_" . $rk,
                        'parse_mode' => 'HTML'
                    ]
                ];
            }
        }
    }

    callBot('answerInlineQuery', [
        'inline_query_id' => $query_id,
        'results' => json_encode($results, JSON_UNESCAPED_UNICODE),
        'cache_time' => 60,
        'is_personal' => true
    ]);
    die('ok');
}

// --- هندل offch_coupon| (بعد از کلیک روی اینلاین تخفیف‌ها) ---
if ($chat_id && strpos($text, 'offch_coupon|') === 0) {
    if (!isUserMember($chat_id)) {
        sendJoinRequired($chat_id);
        die('ok');
    }

    // ساختار: offch_coupon|id|slug|title|pretty|expire
    $parts = explode('|', $text, 6);
    $couponId = $parts[1] ?? '';
    $slug     = $parts[2] ?? '';
    $title    = $parts[3] ?? '';
    $pretty   = $parts[4] ?? '';
    $expire   = $parts[5] ?? '';

    // آدرس صفحهٔ کوپن
    $pageUrl = '';
    if ($couponId !== '') {
        $pageUrl = "https://www.offch.com/codes/" . intval($couponId);
    } elseif ($slug !== '') {
        $pageUrl = strpos($slug, 'http') === 0 ? $slug : 'https://www.offch.com' . $slug;
    }

    $codeVal = '';
    $buyLink = ''; // لینک خرید یا فعال‌سازی (مثل ofch.ir/...)

    if ($pageUrl !== '') {
        $ch = curl_init($pageUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 15);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0 Safari/537.36');
        $html = curl_exec($ch);
        curl_close($ch);

        if ($html) {
            // اولویت اول: __NEXT_DATA__ (همیشه معتبر)
            if (preg_match('/<script id="__NEXT_DATA__" type="application\\/json">(.*?)<\\/script>/s', $html, $m)) {
                $jsonStr = $m[1];
                $data = json_decode($jsonStr, true);
                if (json_last_error() === JSON_ERROR_NONE && is_array($data)) {
                    $coupon = $data['props']['pageProps']['coupon'] ?? null;
                    if (is_array($coupon)) {
                        $codeVal = trim($coupon['code'] ?? '');

                        // استخراج لینک خرید (affiliate_link یا redirect_url)
                        $buyLink = trim($coupon['affiliate_link'] ?? $coupon['redirect_url'] ?? '');

                        // پر کردن اطلاعات اضافی
                        if ($title === '' && !empty($coupon['title'])) $title = trim($coupon['title']);
                        if ($pretty === '' && !empty($coupon['pretty_value'])) $pretty = trim($coupon['pretty_value']);
                        if ($expire === '' && !empty($coupon['pretty_expire_datetime'])) $expire = trim($coupon['pretty_expire_datetime']);
                        elseif ($expire === '' && !empty($coupon['expire_date_persian'])) $expire = trim($coupon['expire_date_persian']);
                    }
                }
            }

            // fallback برای کد (اگر JSON به هر دلیلی کد رو نداد)
            if ($codeVal === '') {
                if (preg_match('/<div[^>]*class="[^"]*text-xl[^"]*font-mono[^"]*font-bold[^"]*"[^>]*>([A-Za-z0-9]+)<\\/div>/u', $html, $m)) {
                    $codeVal = trim($m[1]);
                }
            }

            // fallback برای لینک خرید اگر در JSON نبود (جستجو در HTML)
            if ($buyLink === '') {
                if (preg_match('/<a[^>]+class="[^"]*bg-primary-button[^"]*"[^>]+href="([^"]+)"/u', $html, $m)) {
                    $buyLink = htmlspecialchars_decode($m[1]);
                } elseif (preg_match('/href="(https?:\/\/ofch\.ir\/[^"]+)"/u', $html, $m)) {
                    $buyLink = $m[1];
                }
            }
        }
    }

    // ساخت پیام پایه
    $msg = "🏷️ کد تخفیف";
    if ($title !== '') $msg .= "\n" . $title;
    if ($pretty !== '') $msg .= "\nمقدار: " . $pretty;
    if ($expire !== '') $msg .= "\nاعتبار: " . $expire;

    // کیبورد اینلاین
    $replyMarkup = ['inline_keyboard' => []];

    if ($codeVal !== '') {
        // اگر کد هست → نمایش کد + دکمه کپی (تلگرام خودش کپی می‌کنه با <code>)
        $msg .= "\n\nکد: <code>" . htmlspecialchars($codeVal) . "</code>";
        $msg .= "\n\nکافیه کپی کنی و توی سایت/اپ وارد کنی! 🚀";

        // اگر لینک خرید هم بود، دکمه اضافی
        if ($buyLink !== '') {
            $replyMarkup['inline_keyboard'][] = [
                ['text' => '🛒 خرید با تخفیف', 'url' => $buyLink]
            ];
        }
    } else {
        // اگر کد نبود → حتماً لینک خرید/فعال‌سازی هست
        if ($buyLink !== '') {
            $msg .= "\n\nاین تخفیف <b>بدون کد</b> هست و با کلیک روی دکمه زیر فعال می‌شه:";
            $replyMarkup['inline_keyboard'][] = [
                ['text' => '🛒 فعال‌سازی / خرید با تخفیف', 'url' => $buyLink]
            ];
        } else {
            $msg .= "\n\nمتأسفانه لینک فعال‌سازی هم پیدا نشد. خودت از سایت چک کن:";
            $replyMarkup['inline_keyboard'][] = [
                ['text' => 'مشاهده در سایت', 'url' => $pageUrl]
            ];
        }
    }

    callBot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => $msg,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true,
        'reply_markup' => json_encode($replyMarkup)
    ]);

    die('ok');
}
// --- هندل product_ ---
if ($chat_id && strpos($text, "product_") === 0) {
    if (!isUserMember($chat_id)) {
        sendJoinRequired($chat_id);
        die('ok');
    }
    $random_key = str_replace("product_", "", $text);

    $url = "https://api.torob.com/v4/base-product/details/?random_key=" . urlencode($random_key);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $raw = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($raw, true);

    $name = htmlspecialchars($data['name1'] ?? '---');
    $name2 = $data['name2'] ?? '';
    $price = intval($data['price'] ?? 0);
    $toman = $price > 0 ? tr($price) : 'ناموجود';
    $shop_text = $data['shop_text'] ?? '';

    // بازه قیمت و تعداد فروشنده‌ها
    $min_price = isset($data['min_price']) ? tr($data['min_price']) : null;
    $max_price = isset($data['max_price']) ? tr($data['max_price']) : null;
    $seller_count = $data['products_info']['count'] ?? null;

    // مشخصات کلیدی
    $spec_lines = [];
    $key_specs = $data['key_specs'][0]['items'] ?? [];
    foreach ($key_specs as $spec) {
        $k = $spec['key'] ?? '';
        $vals = $spec['value'] ?? [];
        if (!$k || !is_array($vals) || empty($vals)) continue;
        $v = implode('، ', $vals);
        $spec_lines[] = "• {$k}: {$v}";
    }

    // چند مشخصه مهم از structural_specs (در صورت وجود)
    $struct_specs = $data['structural_specs']['headers'][0]['specs'] ?? [];
    $important_keys = [
        'حافظه داخلی',
        'حافظه رم',
        'ظرفیت باتری',
        'دوربین اصلی',
        'دوربین سلفی',
        'سیستم عامل',
        'وضعیت رجیستری',
        'اصالت کالا',
    ];
    foreach ($important_keys as $ik) {
        if (!empty($struct_specs[$ik])) {
            $spec_lines[] = "• {$ik}: " . $struct_specs[$ik];
        }
    }

    $spec_text = $spec_lines ? ("\n\n🔧 مشخصات کلیدی:\n" . implode("\n", $spec_lines)) : '';

    // هشدار در صورت غیر اصل بودن کالا
    $originality = $struct_specs['اصالت کالا'] ?? '';
    $warn = '';
    if ($originality && stripos($originality, 'غیر اصل') !== false) {
        $warn = "\n\n⚠️ توجه: این کالا اورجینال نیست (های‌کپی / غیر اصل).";
    }

    // متن بازه قیمت و تعداد فروشگاه
    $range_line = '';
    if ($min_price && $max_price && $min_price !== $max_price) {
        $range_line = "💰 بازه قیمت: <b>{$min_price}</b> تا <b>{$max_price}</b>";
    } elseif ($toman) {
        $range_line = "💰 قیمت: <b>{$toman}</b>";
    }
    if ($seller_count) {
        $range_line .= "\n🛍 تعداد فروشگاه‌ها: {$seller_count}";
    }

    $is_fav = isFavoriteByKey($chat_id, $random_key);
    $in_cmp = isInCompareListByKey($chat_id, $random_key);
    $keyboard = buildProductKeyboard($random_key, $is_fav, $in_cmp);

    $msg = "📦 <b>{$name}</b>";
    if ($name2) {
        $msg .= "\n<code>{$name2}</code>";
    }
    if ($range_line) {
        $msg .= "\n\n" . $range_line;
    }
    if ($shop_text) {
        $msg .= "\n🏪 " . $shop_text;
    }
    $msg .= $spec_text . $warn;

    callBot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => $msg,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
    die('ok');
}

// --- Callbacks ---
if ($callback) {
    // ابتدا: اگر callback برای پنل ادمین است، فقط به ادمین‌ها اجازه بده
    if (in_array($callback, ['admin_stats', 'admin_broadcast_info', 'admin_pm_info'], true)) {
        if (!isAdmin($cid_chat)) {
            callBot('answerCallbackQuery', [
                'callback_query_id' => $cid,
                'text' => '❌ شما دسترسی به پنل ادمین ندارید.',
                'show_alert' => true
            ]);
            die('ok');
        }

        if ($callback === 'admin_stats') {
            callBot('answerCallbackQuery', ['callback_query_id' => $cid]);

            $userIds = getAllUserIds();
            $totalUsers = count($userIds);

            $header = "📊 آمار کلی ربات\n\n" .
                      "تعداد کل کاربران ثبت‌شده: <b>{$totalUsers}</b>\n\n" .
                      "لیست کاربران:";

            // برای جلوگیری از محدودیت طول پیام تلگرام (4096 کاراکتر)، خروجی را تکه‌ای می‌فرستیم
            $chunks = [];
            $current = $header;
            $maxLen = 3500;

            // برای اینکه سرعت/فشار API زیاد نشود، اگر تعداد خیلی زیاد بود محدود می‌کنیم
            $maxUsersToShow = 200;
            $shown = 0;

            foreach ($userIds as $uid) {
                $shown++;
                if ($shown > $maxUsersToShow) {
                    break;
                }

                $label = getChatLabelById($uid);
                $line = "\n• " . $label;

                if (mb_strlen($current . $line, 'UTF-8') > $maxLen) {
                    $chunks[] = $current;
                    $current = "📊 لیست کاربران (ادامه)\n" . ltrim($line);
                } else {
                    $current .= $line;
                }
            }

            if ($totalUsers > $maxUsersToShow) {
                $current .= "\n\n... و " . ($totalUsers - $maxUsersToShow) . " کاربر دیگر";
            }

            $chunks[] = $current;

            foreach ($chunks as $part) {
                callBot('sendMessage', [
                    'chat_id' => $cid_chat,
                    'text' => $part,
                    'parse_mode' => 'HTML'
                ]);
            }
            die('ok');
        }

        if ($callback === 'admin_broadcast_info') {
            callBot('answerCallbackQuery', ['callback_query_id' => $cid]);

            $txt = "📢 <b>راهنمای پیام همگانی</b>\n\n" .
                   "فرمت دستور:\n" .
                   "/broadcast متن پیام\n\n" .
                   "مثال:\n" .
                   "/broadcast سلام، این یک پیام تست از طرف ادمین است.";

            callBot('sendMessage', [
                'chat_id' => $cid_chat,
                'text' => $txt,
                'parse_mode' => 'HTML'
            ]);
            die('ok');
        }

        if ($callback === 'admin_pm_info') {
            callBot('answerCallbackQuery', ['callback_query_id' => $cid]);

            $txt = "✉️ <b>راهنمای پیام به کاربر</b>\n\n" .
                   "فرمت دستور:\n" .
                   "/pm chat_id متن پیام\n\n" .
                   "مثال:\n" .
                   "/pm 123456789 سلام، این یک پیام تست است.";

            callBot('sendMessage', [
                'chat_id' => $cid_chat,
                'text' => $txt,
                'parse_mode' => 'HTML'
            ]);
            die('ok');
        }
    }

    if ($callback === 'check_membership') {
        callBot('answerCallbackQuery', ['callback_query_id' => $cid]);
        if (isUserMember($cid_chat)) {

            callBot('sendMessage', [
                'chat_id' => $cid_chat,
                'text' => "✅ تأیید شد!\nحالا می‌توانید از همه امکانات ربات استفاده کنید.\n\nبرای شروع، دستور /start را در ربات ارسال کنید.",
                'parse_mode' => 'HTML'
            ]);

            // اگر این کاربر با لینک دعوت آمده و هنوز جایزه‌اش به معرف داده نشده، همین‌جا یک بار امتیاز بده
            rewardReferralIfNeeded($cid_chat);
        } else {
            sendJoinRequired($cid_chat);
        }
        die('ok');
    }

    // برای همهٔ callbackهای دیگر، قبل از اجرا عضویت را چک کن
    if (!isUserMember($cid_chat)) {
        callBot('answerCallbackQuery', ['callback_query_id' => $cid]);
        sendJoinRequired($cid_chat);
        die('ok');
    }

    if ($callback === 'favorites') {

        $txt = "⭐ <b>لیست علاقه‌مندی‌ها</b>\n\n" .
               "برای دیدن علاقه‌مندی‌ها روی دکمهٔ زیر بزن:\n\n" .
               "بعد از باز شدن اینلاین، 'love_list' را برای خودت ارسال کن.";

        $kb = json_encode([
            'inline_keyboard' => [
                [
                    ['text' => '📂 نمایش علاقه‌مندی‌ها', 'switch_inline_query_current_chat' => 'love_list']
                ],
                [
                    ['text' => '⬅️ بازگشت به منوی اصلی', 'callback_data' => 'main_menu']
                ]
            ]
        ]);

        callBot('answerCallbackQuery', ['callback_query_id' => $cid]);

        if ($mid) {
            // اگر از منوی اصلی آمده، همان پیام را ویرایش کن
            callBot('editMessageText', [
                'chat_id' => $cid_chat,
                'message_id' => $mid,
                'text' => $txt,
                'parse_mode' => 'HTML',
                'reply_markup' => $kb
            ]);
        } else {
            // در غیر این صورت یک پیام جدید ارسال کن
            callBot('sendMessage', [
                'chat_id' => $cid_chat,
                'text' => $txt,
                'parse_mode' => 'HTML',
                'reply_markup' => $kb
            ]);
        }
    } elseif ($callback === 'earn_points') {
        $points = getPoints($cid_chat);
        $link = "https://t.me/" . BOT_USERNAME . "?start=" . $cid_chat;

        $txt = "🏆 <b>سیستم سادهٔ امتیاز</b>\n\n" .
               "امتیاز فعلی تو: <b>{$points}</b>\n\n" .
               "هر کاربر جدیدی که با لینک دعوت تو وارد ربات شود، ۱ امتیاز به تو اضافه می‌شود.\n\n" .
               "🔗 لینک دعوت اختصاصی تو:\n" . $link . "\n\n" .
               "برای اشتراک‌گذاری راحت، از دکمهٔ زیر استفاده کن.";

        $kb = json_encode([
            'inline_keyboard' => [
                [
                    ['text' => '📤 اشتراک‌گذاری لینک دعوت', 'switch_inline_query' => 'share_link']
                ],
                [
                    ['text' => '⬅️ بازگشت به منوی اصلی', 'callback_data' => 'main_menu']
                ]
            ]
        ]);

        callBot('answerCallbackQuery', ['callback_query_id' => $cid]);

        if ($mid) {
            // اگر روی دکمه از منوی اصلی زده شده، همان پیام را ویرایش کن
            callBot('editMessageText', [
                'chat_id' => $cid_chat,
                'message_id' => $mid,
                'text' => $txt,
                'parse_mode' => 'HTML',
                'reply_markup' => $kb
            ]);
        } else {
            // در غیر این صورت یک پیام جدید بفرست
            callBot('sendMessage', [
                'chat_id' => $cid_chat,
                'text' => $txt,
                'parse_mode' => 'HTML',
                'reply_markup' => $kb
            ]);
        }
    } elseif ($callback === 'report_bug') {
        callBot('answerCallbackQuery', ['callback_query_id' => $cid]);
        callBot('sendMessage', ['chat_id' => $cid_chat, 'text' => "🔐 برای ریپورت باگ، به @brrssm پیام دهید"]);
    } elseif ($callback === 'main_menu') {
        callBot('answerCallbackQuery', ['callback_query_id' => $cid]);
        if ($mid) {
            // ویرایش همان پیام برای برگشت به منوی اصلی
            $keyboard = json_encode([
                'inline_keyboard' => [
                    [
                        ['text' => '🔍 جستجوی کالا', 'switch_inline_query_current_chat' => '']
                    ],
                    [
                        ['text' => '🏷️ تخفیف‌یاب', 'switch_inline_query_current_chat' => 'deals'],
                        ['text' => '🏆 کسب امتیاز', 'callback_data' => 'earn_points']
                    ],
                    [
                        ['text' => '⭐ علاقه‌مندی‌ها', 'callback_data' => 'favorites']
                    ],
                    [
                        ['text' => '📊 مقایسهٔ کالاها', 'callback_data' => 'cmp_show']
                    ],
                    [
                        ['text' => '🐞 ریپورت باگ', 'callback_data' => 'report_bug']
                    ]
                ]
            ]);

            callBot('editMessageText', [
                'chat_id' => $cid_chat,
                'message_id' => $mid,
                'text' => "🤖 <b>ربات کالا یاب هیسکا</b>\n\n" .
                          "💰 پایین‌ترین قیمت‌ها رو در ۲۰۰+ فروشگاه معتبر ایرانی پیدا کنید!\n" .
                          "⚡ جستجوی لحظه‌ای — بدون ثبت‌نام — بدون تبلیغات\n\n" .
                          "👇 برای شروع، دکمه زیر را بزنید و اسم کالایی که می‌خواهید را وارد کنید:",
                'parse_mode' => 'HTML',
                'reply_markup' => $keyboard
            ]);
        } else {
            // اگر به هر دلیل message_id نداشتیم، یک منوی اصلی جدید ارسال کن
            $keyboard = json_encode([
                'inline_keyboard' => [
                    [
                        ['text' => '🔍 جستجوی کالا', 'switch_inline_query_current_chat' => '']
                    ],
                    [
                        ['text' => '🏷️ تخفیف‌یاب', 'callback_data' => 'deals'],
                        ['text' => '🏆 کسب امتیاز', 'callback_data' => 'earn_points']
                    ],
                    [
                        ['text' => '⭐ علاقه‌مندی‌ها', 'callback_data' => 'favorites']
                    ],
                    [
                        ['text' => '📊 مقایسهٔ کالاها', 'callback_data' => 'cmp_show']
                    ],
                    [
                        ['text' => '🐞 ریپورت باگ', 'callback_data' => 'report_bug']
                    ]
                ]
            ]);

            callBot('sendMessage', [
                'chat_id' => $cid_chat,
                'text' => "🤖 <b>ربات کالا یاب هیسکا</b>\n\n" .
                          "💰 پایین‌ترین قیمت‌ها رو در ۲۰۰+ فروشگاه معتبر ایرانی پیدا کنید!\n" .
                          "⚡ جستجوی لحظه‌ای — بدون ثبت‌نام — بدون تبلیغات\n\n" .
                          "👇 برای شروع، دکمه زیر را بزنید و اسم کالایی که می‌خواهید را وارد کنید:",
                'parse_mode' => 'HTML',
                'reply_markup' => $keyboard
            ]);
        }
    } elseif (preg_match('/^cmp_add:(.+)$/', $callback, $m)) {
        $random_key = $m[1];
        $user_id = $cid_chat;

        if (isInCompareListByKey($user_id, $random_key)) {
            callBot('answerCallbackQuery', [
                'callback_query_id' => $cid,
                'text' => 'این کالا قبلاً در لیست مقایسه است.',
                'show_alert' => false
            ]);
            die('ok');
        }

        $list = getCompareList($user_id);
        if (count($list) >= 2) {
            callBot('answerCallbackQuery', [
                'callback_query_id' => $cid,
                'text' => 'الان ۲ کالا در لیست مقایسه‌ات هست؛ یکی را حذف کن.',
                'show_alert' => true
            ]);
            die('ok');
        }

        $url = "https://api.torob.com/v4/base-product/details/?random_key=" . urlencode($random_key);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $raw = curl_exec($ch);
        $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($http !== 200 || !$raw) {
            callBot('answerCallbackQuery', [
                'callback_query_id' => $cid,
                'text' => 'خطا در افزودن به مقایسه.',
                'show_alert' => true
            ]);
            die('ok');
        }

        $data = json_decode($raw, true);
        $name = htmlspecialchars($data['name1'] ?? '---');
        $price = intval($data['price'] ?? 0);
        $image_url = $data['image_url'] ?? '';

        $key_specs_items = $data['key_specs'][0]['items'] ?? [];
        $key_specs = [];
        if (is_array($key_specs_items)) {
            foreach ($key_specs_items as $spec) {
                $k = trim($spec['key'] ?? '');
                $vals = $spec['value'] ?? [];
                if (!$k) continue;
                if (is_array($vals)) {
                    $vals = array_filter(array_map('trim', $vals), fn($x) => $x !== '');
                    $v = implode('، ', $vals);
                } else {
                    $v = trim((string)$vals);
                }
                if ($v === '') continue;
                $key_specs[$k] = $v;
            }
        }

        // اضافه‌کردن مشخصات ساختاری (structural_specs) برای غنی‌تر شدن مقایسه
        $struct_specs_all = $data['structural_specs']['headers'][0]['specs'] ?? [];
        if (is_array($struct_specs_all)) {
            foreach ($struct_specs_all as $k => $v) {
                $k = trim((string)$k);
                $v = is_array($v) ? trim(implode('، ', $v)) : trim((string)$v);
                if ($k === '' || $v === '') continue;
                // اگر قبلاً در key_specs نبود، اضافه‌اش کن
                if (!isset($key_specs[$k])) {
                    $key_specs[$k] = $v;
                }
            }
        }

        // جلوگیری از مقایسهٔ کالاهای کاملاً نامرتبط (مثلاً یخچال با تلویزیون)
        if (!empty($list)) {
            $other = $list[0];
            $otherSpecs = $other['key_specs'] ?? [];
            if (is_array($otherSpecs)) {
                $newKeys = array_keys($key_specs);
                $otherKeys = array_keys($otherSpecs);
                $common = array_intersect($newKeys, $otherKeys);
                if (count($common) < 2) {
                    callBot('answerCallbackQuery', [
                        'callback_query_id' => $cid,
                        'text' => 'این دو کالا قابل مقایسه نیستند؛ لطفاً دو کالای مشابه (مثلاً دو تا تلویزیون) را برای مقایسه انتخاب کن.',
                        'show_alert' => true
                    ]);
                    die('ok');
                }
            }
        }

        $product = [
            'random_key'    => $random_key,
            'name'          => $name,
            'price'         => $price,
            'image_url'     => $image_url,
            'category_path' => null,
            'key_specs'     => $key_specs,
        ];

        if (!addToCompareList($user_id, $product)) {
            callBot('answerCallbackQuery', [
                'callback_query_id' => $cid,
                'text' => 'خطا در افزودن به مقایسه.',
                'show_alert' => true
            ]);
            die('ok');
        }

        callBot('answerCallbackQuery', [
            'callback_query_id' => $cid,
            'text' => 'به لیست مقایسه اضافه شد.',
            'show_alert' => false
        ]);

        if ($mid) {
            $is_fav = isFavoriteByKey($cid_chat, $random_key);
            $kb = buildProductKeyboard($random_key, $is_fav, true);
            callBot('editMessageReplyMarkup', [
                'chat_id' => $cid_chat,
                'message_id' => $mid,
                'reply_markup' => $kb
            ]);
        }
    } elseif (preg_match('/^cmp_remove:(.+)$/', $callback, $m)) {
        $random_key = $m[1];
        $user_id = $cid_chat;

        if (!removeFromCompareListByKey($user_id, $random_key)) {
            callBot('answerCallbackQuery', [
                'callback_query_id' => $cid,
                'text' => 'این کالا در لیست مقایسه نبود.',
                'show_alert' => false
            ]);
            die('ok');
        }

        callBot('answerCallbackQuery', [
            'callback_query_id' => $cid,
            'text' => '❌ از لیست مقایسه حذف شد.',
            'show_alert' => false
        ]);

        if ($mid) {
            $is_fav = isFavoriteByKey($cid_chat, $random_key);
            $kb = buildProductKeyboard($random_key, $is_fav, false);
            callBot('editMessageReplyMarkup', [
                'chat_id' => $cid_chat,
                'message_id' => $mid,
                'reply_markup' => $kb
            ]);
        }
    } elseif ($callback === 'cmp_show') {
        $user_id = $cid_chat;
        $list = getCompareList($user_id);

        $countList = count($list);
        if ($countList === 0) {
            callBot('answerCallbackQuery', [
                'callback_query_id' => $cid,
                'text' => 'الان هیچ کالایی تو لیست مقایسه‌ات نیست.',
                'show_alert' => true
            ]);
            die('ok');
        }

        if ($countList === 1) {
            // فقط یک کالا در لیست است؛ پیام راهنما بفرست
            callBot('answerCallbackQuery', ['callback_query_id' => $cid]);

            $hint_text = "📊 یک کالا تو لیست مقایسه‌ات هست.\n\n" .
                         "برای مقایسه، یک محصول دوم هم به لیست اضافه کن.";

            $hint_kb = json_encode([
                'inline_keyboard' => [
                    [
                        ['text' => '➕ افزودن محصول دوم', 'switch_inline_query_current_chat' => '']
                    ],
                    [
                        ['text' => '🗑 پاک کردن لیست مقایسه', 'callback_data' => 'cmp_clear']
                    ],
                    [
                        ['text' => '⬅️ بازگشت به منوی اصلی', 'callback_data' => 'main_menu']
                    ]
                ]
            ]);

            callBot('sendMessage', [
                'chat_id' => $cid_chat,
                'text' => $hint_text,
                'parse_mode' => 'HTML',
                'reply_markup' => $hint_kb
            ]);
            die('ok');
        }

        // تایید بی‌صدا برای بستن لودینگ دکمه وقتی واقعاً دو کالا برای مقایسه داریم
        callBot('answerCallbackQuery', ['callback_query_id' => $cid]);

        $normalize_specs = function ($specs) {
            if (!is_array($specs)) return [];
            $keys = array_keys($specs);
            $is_list = $keys === range(0, count($specs) - 1);
            if (!$is_list) return $specs;

            $out = [];
            foreach ($specs as $spec) {
                if (!is_array($spec)) continue;
                $k = trim($spec['key'] ?? '');
                $vals = $spec['value'] ?? [];
                if (!$k) continue;
                if (is_array($vals)) {
                    $vals = array_filter(array_map('trim', $vals), fn($x) => $x !== '');
                    $v = implode('، ', $vals);
                } else {
                    $v = trim((string)$vals);
                }
                if ($v === '') continue;
                $out[$k] = $v;
            }
            return $out;
        };

        $a = $list[0];
        $b = $list[1];

        $a['key_specs'] = $normalize_specs($a['key_specs'] ?? []);
        $b['key_specs'] = $normalize_specs($b['key_specs'] ?? []);

        $nameA = $a['name'] ?? '---';
        $nameB = $b['name'] ?? '---';
        $priceA = isset($a['price']) ? tr($a['price']) : 'ناموجود';
        $priceB = isset($b['price']) ? tr($b['price']) : 'ناموجود';

        $msg = "📊 <b>مقایسه دو کالا</b>\n\n" .
               "۱️⃣ <b>{$nameA}</b>\n💰 {$priceA}\n\n" .
               "۲️⃣ <b>{$nameB}</b>\n💰 {$priceB}\n\n" .
               "🔧 <b>مشخصات کلیدی:</b>";

        // همه کلیدهای موجود در مشخصات دو کالا را جمع می‌کنیم؛ اول مشترک‌ها، بعد بقیه
        $keysA = array_keys($a['key_specs']);
        $keysB = array_keys($b['key_specs']);
        $commonKeys = array_values(array_intersect($keysA, $keysB));
        $aOnly = array_values(array_diff($keysA, $commonKeys));
        $bOnly = array_values(array_diff($keysB, array_merge($commonKeys, $aOnly)));
        $allKeys = array_merge($commonKeys, $aOnly, $bOnly);

        // مرتب‌سازی حروفی هر دسته برای ظاهر بهتر
        $sortSegment = function (&$arr) {
            sort($arr, SORT_STRING | SORT_FLAG_CASE);
        };
        $sortSegment($commonKeys);
        $sortSegment($aOnly);
        $sortSegment($bOnly);
        $allKeys = array_merge($commonKeys, $aOnly, $bOnly);

        $maxSpecs = 40; // حداکثر ۴۰ مشخصه برای جلوگیری از خیلی طولانی شدن
        $count = 0;
        foreach ($allKeys as $k) {
            $va = $a['key_specs'][$k] ?? '—';
            $vb = $b['key_specs'][$k] ?? '—';
            $msg .= "\n\n<b>{$k}</b>" .
                    "\n• کالا ۱: {$va}" .
                    "\n• کالا ۲: {$vb}";
            $count++;
            if ($count >= $maxSpecs) break;
        }

        $cmpKb = json_encode([
            'inline_keyboard' => [
                [
                    ['text' => '📂 مشاهده محصولات لیست', 'switch_inline_query_current_chat' => 'cmp_list']
                ],
                [
                    ['text' => '📊 مقایسهٔ دوباره', 'callback_data' => 'cmp_show']
                ],
                [
                    ['text' => '🗑 پاک کردن لیست مقایسه', 'callback_data' => 'cmp_clear']
                ],
                [
                    ['text' => '⬅️ بازگشت به منوی اصلی', 'callback_data' => 'main_menu']
                ]
            ]
        ]);

        callBot('sendMessage', [
            'chat_id' => $cid_chat,
            'text' => $msg,
            'parse_mode' => 'HTML',
            'reply_markup' => $cmpKb
        ]);
    } elseif ($callback === 'cmp_clear') {
        $user_id = $cid_chat;
        setCompareList($user_id, []);
        callBot('answerCallbackQuery', [
            'callback_query_id' => $cid,
            'text' => 'لیست مقایسه خالی شد.',
            'show_alert' => false
        ]);
    } elseif (preg_match('/^fav_add:(.+)$/', $callback, $m)) {
        $random_key = $m[1];
        $user_id = $cid_chat;

        if (isFavoriteByKey($user_id, $random_key)) {
            callBot('answerCallbackQuery', [
                'callback_query_id' => $cid,
                'text' => 'این کالا قبلاً در علاقه‌مندی‌هاست.',
                'show_alert' => false
            ]);
            die('ok');
        }

        $url = "https://api.torob.com/v4/base-product/details/?random_key=" . urlencode($random_key);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $raw = curl_exec($ch);
        $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($http !== 200 || !$raw) {
            callBot('answerCallbackQuery', [
                'callback_query_id' => $cid,
                'text' => '❌ خطا در افزودن به علاقه‌مندی‌ها.',
                'show_alert' => true
            ]);
            die('ok');
        }

        $data = json_decode($raw, true);
        if (!$data || empty($data['name1'])) {
            callBot('answerCallbackQuery', [
                'callback_query_id' => $cid,
                'text' => '⚠️ اطلاعات محصول ناقص است.',
                'show_alert' => true
            ]);
            die('ok');
        }

        $name = htmlspecialchars($data['name1'] ?? '---');
        $price = intval($data['price'] ?? 0);
        $image_url = $data['image_url'] ?? '';

        $product = [
            'random_key' => $random_key,
            'name'       => $name,
            'price'      => $price,
            'image_url'  => $image_url,
        ];

        if (!addFavorite($user_id, $product)) {
            callBot('answerCallbackQuery', [
                'callback_query_id' => $cid,
                'text' => '❌ خطا در ذخیرهٔ علاقه‌مندی.',
                'show_alert' => true
            ]);
            die('ok');
        }

        callBot('answerCallbackQuery', [
            'callback_query_id' => $cid,
            'text' => '⭐ به لیست علاقه‌مندی‌ها اضافه شد.',
            'show_alert' => false
        ]);

        if ($mid) {
            $in_cmp = isInCompareListByKey($cid_chat, $random_key);
            $kb = buildProductKeyboard($random_key, true, $in_cmp);
            callBot('editMessageReplyMarkup', [
                'chat_id' => $cid_chat,
                'message_id' => $mid,
                'reply_markup' => $kb
            ]);
        }
    } elseif (preg_match('/^fav_remove:(.+)$/', $callback, $m)) {
        $random_key = $m[1];
        $user_id = $cid_chat;

        if (!removeFavoriteByKey($user_id, $random_key)) {
            callBot('answerCallbackQuery', [
                'callback_query_id' => $cid,
                'text' => 'این کالا از قبل در علاقه‌مندی‌ها نبود.',
                'show_alert' => false
            ]);
            die('ok');
        }

        callBot('answerCallbackQuery', [
            'callback_query_id' => $cid,
            'text' => '❌ از لیست علاقه‌مندی‌ها حذف شد.',
            'show_alert' => false
        ]);

        if ($mid) {
            $in_cmp = isInCompareListByKey($cid_chat, $random_key);
            $kb = buildProductKeyboard($random_key, false, $in_cmp);
            callBot('editMessageReplyMarkup', [
                'chat_id' => $cid_chat,
                'message_id' => $mid,
                'reply_markup' => $kb
            ]);
        }
    }
}

die('ok');